package;

#if discord_rpc
import Discord.DiscordClient;
#end
import flixel.util.FlxTimer;
import flixel.FlxState;
import ui.MenuItem;
import ui.MenuTypedList;
import ui.AtlasMenuItem;
import ui.OptionsState;
import ui.PreferencesMenu;
import flixel.FlxG;
import flixel.FlxObject;
import flixel.FlxSprite;
import flixel.addons.transition.FlxTransitionableState;
import flixel.effects.FlxFlicker;
import flixel.graphics.frames.FlxAtlasFrames;
import flixel.group.FlxGroup.FlxTypedGroup;
import flixel.text.FlxText;
import flixel.tweens.FlxEase;
import flixel.tweens.FlxTween;
import flixel.util.FlxColor;
import lime.app.Application;

import openfl.utils.Assets;
#if sys
import sys.io.File;
#end

class MainMenuState extends MusicBeatState {
	var menuItems:MainMenuList;

	var magenta:FlxSprite;
	var camFollow:FlxObject;

	override function create() {
		#if discord_rpc
		DiscordClient.changePresence('In the Menus', null);
		#end

		if (!FlxG.sound.music.playing)
			FlxG.sound.playMusic(Paths.music('freakyMenu'));

		persistentUpdate = persistentDraw = true;

		var bg:FlxSprite = new FlxSprite(null, null, Paths.image('ui/menus/menuBG'));
		bg.scrollFactor.set(0, 0.17);
		bg.setGraphicSize(Std.int(bg.width * 1.2));
		bg.updateHitbox();
		bg.screenCenter();
		add(bg);

		camFollow = new FlxObject(0, 0, 1, 1);
		add(camFollow);

		magenta = new FlxSprite(null, null, Paths.image('ui/menus/menuDesat'));
		magenta.scrollFactor.set(bg.scrollFactor.x, bg.scrollFactor.y);
		magenta.setGraphicSize(Std.int(bg.width));
		magenta.updateHitbox();
		magenta.setPosition(bg.x, bg.y);
		magenta.visible = false;
		magenta.color = 0xFFFD719B;
		if (PreferencesMenu.preferences.get('flashing-menu'))
			add(magenta);

		menuItems = new MainMenuList();
		menuItems.enabled = false;
		add(menuItems);
		menuItems.onChange.add(onMenuItemChange);
		menuItems.onAcceptPress.add(function(item:MenuItem) FlxFlicker.flicker(magenta, 1.1, 0.15, false, true));
		menuItems.createItem(null, null, 'MODDIFICIL', function() playWeek('1dificil'));
		menuItems.createItem(null, null, 'FREEPLAY', function() startExitState(new FreeplayState()));
		menuItems.createItem(0, 0, 'OPTIONS', function() startExitState(new OptionsState()));
		menuItems.createItem(0, 0, 'CREDITS', function() startExitState(new CreditsState()));

		var pos:Float = (FlxG.height - 160 * (menuItems.length - 1)) / 2;
		for (i in 0...menuItems.length) {
			var item:MainMenuItem = menuItems.members[i];
			item.x = FlxG.width / 2;
			item.y = pos + (160 * i);
		}

		FlxG.camera.follow(camFollow, null, 0.06);

		var versionShit:FlxText = new FlxText(5, FlxG.height - 18, 0, 'MOD DIFICIL ver.' + Application.current.meta.get('version') + ' RRRAHGGHAGHHHHHH (Portal Especulamente exclusive)', 12);
		versionShit.scrollFactor.set();
		versionShit.setFormat('VCR OSD Mono', 16, FlxColor.WHITE, LEFT, FlxTextBorderStyle.OUTLINE, FlxColor.BLACK);
		add(versionShit);

		super.create();
	}

	override function finishTransIn() {
		super.finishTransIn();
		menuItems.enabled = true;
	}

	function onMenuItemChange(item:MenuItem)
		camFollow.setPosition(item.getGraphicMidpoint().x, item.getGraphicMidpoint().y);

	function startExitState(nextState:FlxState) {
		menuItems.enabled = false;
		menuItems.forEach(function(item:MainMenuItem) {
			if (menuItems.selectedIndex != item.ID)
				FlxTween.tween(item, {alpha: 0}, 0.4, {ease: FlxEase.quadOut});
			else
				item.visible = false;
		});
		new FlxTimer().start(0.4, function(tmr:FlxTimer) FlxG.switchState(nextState));
	}
	
	function playWeek(filename:String){
		var weekPath:String = 'assets/data/weeks/' + filename + '.xml';
		var trueSongs:Array<String> = [];
		
		if (!CoolUtil.fileExists(weekPath)) return;
		
			#if sys
			var weekXml:Xml = Xml.parse(File.getContent(weekPath));
			#else
			var weekXml:Xml = Xml.parse(Assets.getText(weekPath));
			#end
			
			// week parser!
			var root:Xml = weekXml.firstElement();
			var storyIter = root.elementsNamed("StoryInfo");
			if (storyIter.hasNext()) {
					var unlock:String = root.get("unlocked");
					
					if (StoryMenuState.weekUnlocked.get(root.get("name")) == null) {
						if (unlock != null && unlock == "false") StoryMenuState.weekUnlocked.set(root.get("name"), false);
						else StoryMenuState.weekUnlocked.set(root.get("name"), true);
					}
					
					// Songs
					for (song in root.elementsNamed("Song")) {
						var songName:String = song.get("name");
						if (songName != null && song.get("dipshit") == FreeplayState.dipshit) trueSongs.push(songName);
					}
			}
		
			PlayState.storyPlaylist = trueSongs;
			PlayState.isStoryMode = true;

			PlayState.storyDifficulty = 1;

			PlayState.SONG = Song.loadFromJson(PlayState.storyPlaylist[0].toLowerCase(), PlayState.storyPlaylist[0].toLowerCase());
			PlayState.storyWeek = root.get("name");
			PlayState.campaignScore = 0;
			
			new FlxTimer().start(1, function(tmr:FlxTimer) {
				startExitState(new PlayState());
			});
	}

	override function update(elapsed:Float) {
		FlxG.camera.followLerp = MathFunctions.fixedLerpValue(0.06);

		if (FlxG.sound.music.volume < 0.8)
			FlxG.sound.music.volume += 0.5 * FlxG.elapsed;
		if (_exiting)
			menuItems.enabled = false;
		if (controls.BACK && menuItems.enabled && !menuItems.busy)
			FlxG.switchState(new TitleState());

		super.update(elapsed);
	}
}

class MainMenuItem extends AtlasMenuItem {
	public function new(?x:Float = 0, ?y:Float = 0, name:String, atlas:FlxAtlasFrames, callback:Dynamic) {
		super(x, y, name, atlas, callback);
		this.scrollFactor.set();
	}

	override public function changeAnim(anim:String) {
		super.changeAnim(anim);
		origin.set(frameWidth * 0.5, frameHeight * 0.5);
		offset.copyFrom(origin);
	}
}

class MainMenuList extends MenuTypedList<MainMenuItem> {
	var atlas:FlxAtlasFrames;

	public function new() {
		atlas = Paths.getSparrowAtlas('ui/menus/main_menu');
		super(Vertical);
	}

	public function createItem(?x:Float = 0, ?y:Float = 0, name:String, callback:Dynamic = null, fireInstantly:Bool = false) {
		var item:MainMenuItem = new MainMenuItem(x, y, name, atlas, callback);
		item.fireInstantly = fireInstantly;
		item.ID = length;
		return addItem(name, item);
	}
}
