var boomboxleft:FlxSprite;
var boomboxright:FlxSprite;

function onCreatePost() {
	game.playHUD.showRating = false;
	game.playHUD.showRatingNum = false;
	
	game.modManager.setValue("opponentSwap", 0.5);
	game.modManager.setValue("alpha", 1, 1);
			
	for (note in game.unspawnNotes) {
		note.noteSplashDisabled = true;
		// note.scale.y = note.scale.x;
	}
		
	var hudShits = [healthBar, timeBar, iconP1, iconP2, scoreTxt, timeTxt];
		
	for (thing in hudShits) {
		thing.visible = false;
	}
	
	switch (PlayState.SONG.arrowSkin) {
		case 'steve':
			game.modManager.setValue("transform0X", -111 * 1.5);
			game.modManager.setValue("transform1X", 111 * 1.5);
			game.modManager.setValue("transform2X", -111 * 1.5);
			game.modManager.setValue("transform3X", 111 * 1.5);
			
			if (ClientPrefs.downScroll) game.modManager.setValue("transformY", -100);
		case 'coold':
			game.modManager.setValue("transform3X", -333);
			game.modManager.setValue("transform2X", -111);
			game.modManager.setValue("transform0X", 222);
			game.modManager.setValue("transform1X", 222);

			boomboxleft = new FlxSprite(160, FlxG.height - 281).loadGraphic(Paths.image('boombok'));
			boomboxleft.cameras = [camHUD];
			add(boomboxleft);
			boomboxleft.origin.set(boomboxleft.width / 2, 240);
			boomboxleft.scale.set(0.1, 0.1);
			
			FlxTween.tween(boomboxleft.scale, { x:1, y:1 }, 1);
			
			boomboxright = new FlxSprite(FlxG.width - 241 - 160, FlxG.height - 281).loadGraphic(Paths.image('boombok'));
			boomboxright.flipX = true;
			boomboxright.cameras = [camHUD];
			add(boomboxright);
			boomboxright.origin.set(boomboxright.width / 2, 240);
			boomboxright.scale.set(0.1, 0.1);
			
			FlxTween.tween(boomboxright.scale, { x:1, y:1 }, 1);
	}
}

function onBeatHit() {
	if (PlayState.SONG.arrowSkin == 'coold') {
		boomboxleft.scale.set(1.05, 1.05);
		FlxTween.tween(boomboxleft.scale, { x:1, y:1 }, 0.2);
		
		boomboxright.scale.set(1.05, 1.05);
		FlxTween.tween(boomboxright.scale, { x:1, y:1 }, 0.2);
	}
}

function goodNoteHit(note) {
	if (PlayState.SONG.arrowSkin == 'coold') {
		var coolNote:FlxSprite = new FlxSprite(0,0);
		coolNote.frames = Paths.getSparrowAtlas('noteskin');
		coolNote.animation.addByPrefix('ar0', 'arrow left');
		coolNote.animation.addByPrefix('ar1', 'arrow down');
		coolNote.animation.addByPrefix('ar2', 'arrow up');
		coolNote.animation.addByPrefix('ar3', 'arrow right');
		
		add(coolNote);
		coolNote.animation.play('ar' + note.noteData);
		coolNote.x = note.x - 24;
		coolNote.y = note.y - 24;
		coolNote.cameras = [camHUD];
		coolNote.scale.set(note.scale.x, note.scale.x);
		// coolNote.origin.set(0, -24);
		
		FlxTween.tween(coolNote, { alpha: 0 }, 0.5);
		FlxTween.tween(coolNote.scale, { x:1.1, y:1.1 }, 0.5);
	}
}

function onUpdate(elapsed) {
	game.modManager.setValue("alpha", 1, 1);
}